﻿using System;

namespace Test
{
    // deklaracja ograniczonej do minimum klasy Cat
    public class Cat
    {
        // prywatna składowa statyczna przechowująca liczbę utworzonych obiektów klasy Cat
        private static int instances = 0;
        private int weight;
        private String name;

        // konstruktor obiektów typu Cat zwiększa zmienną liczącą koty
        public Cat(String name, int weight)
        {
            instances++;
            this.name = name;
            this.weight = weight;
        }

        // metoda statyczna podająca bieżącą liczbę obiektów typu Cat
        public static void HowManyCats()
        {
            Console.WriteLine("Zaadoptowano {0} kot(a/y/ów)", instances);
        }
        public void TellWeight()
        {
            Console.WriteLine("{0} waży {1} kilogram(-/y/ów)", name, weight);
        }
    }

    class Tester
    {
        public void Run()
        {
            Cat.HowManyCats();
            Cat frisky = new Cat("Filemon", 2);
            frisky.TellWeight();
            Cat.HowManyCats();
            Cat whiskers = new Cat("Bonifacy", 3);
            whiskers.TellWeight();
            Cat.HowManyCats();
        }

        static void Main()
        {
            Tester t = new Tester();
            t.Run();
        }
    }
}